#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Power DiagramMod01.fsh   by   tomkh
//https://www.shadertoy.com/view/4tV3z3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// by Tomasz Dobrowolski' 2016-10-08

// +LMB to see distance to circles

// Relatively fast method to find closest distance to edges of Power diagram,
// a weighted Voronoi diagram with squared weight subtracted from squared distance.
// The edge between Power diagram of cells A and B can be also interpreted 
// as a segment spanned by intersection points of circles centered at A and B 
// with radii equal to respective weights. If sum of weights is bigger than the distance 
// between A and B, i.e. circles do not intersect, formula still holds.

// PolyCube version: 
//   http://polycu.be/edit/?h=cdpAH4 - Power Diagram
//   http://polycu.be/edit/?h=Gbhigy - Fast Voronoi Edges

// ShaderToy references:
//   https://www.shadertoy.com/view/llG3zy - My Fast Voronoi Edges (improved/corrected)
//   https://www.shadertoy.com/view/ldl3W8 - IQ's Distance to Voronoi Edges
//   https://www.shadertoy.com/view/4djSRW - Dave Hoskins wonderful hash functions

#define SHOW_MODE 2
 // 0 = Distance to edge + mouse cursor for inspection
 // 1 = Distance to circle + mouse cursor for inspection
 // 2 = Display both and switch while pressing LMB

#define ACCURACY 2
 // 0 = 3x3 both passes
 // 1 = 3x3 + 4x4 (fast + decent accuracy)
 // 2 = 4x4 both passes (improved accuracy)

#define ANIMATE

// How far cells can go off center during animation (must be <= .5)
#define ANIMATE_D .5

// Points cannot be closer than sqrt(EPSILON)
#define EPSILON .0001

// Max. distance
#define MAX_D 9999.

vec3 hash32(vec2 p)
{
   // Dave Hoskin's hash as in https://www.shadertoy.com/view/4djSRW
   vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yxz+19.19);
   vec3 o = fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));
   #ifdef ANIMATE
   o.z = 0.5 + ANIMATE_D*sin( iTime + o.z*6.283185 );
   #endif
   o.z *= 0.7071; // limit weight to 0..sqrt(2)/2 range
   return o;
}

// Returns distance to closest circle with radius = weight
float closest_circle( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);
    #if ACCURACY == 2
    // shift by half-cell
    vec2 h = step(.5,f) - 2.;
    n += h; f -= h;
    #endif

    float md = MAX_D;
    vec3 mr;
    #if ACCURACY == 2
    for( int j=0; j<=3; j++ )
    for( int i=0; i<=3; i++ )
    #else
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    #endif
    {
        vec2 g = vec2(float(i),float(j));
        vec3 o = hash32( n + g );
        vec2 r = g + o.xy - f;
        md = min( md, length(r) - o.z );
    }
    
    return md;
}

// Power diagram-based continuous noise function (not used here)
float power_noise( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);
    #if ACCURACY == 2
    // shift by half-cell
    vec2 h = step(.5,f) - 2.;
    n += h; f -= h;
    #endif

    float md = MAX_D;
    #if ACCURACY == 2
    for( int j=0; j<=3; j++ )
    for( int i=0; i<=3; i++ )
    #else
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    #endif
    {
        vec2 g = vec2(float(i),float(j));
        vec3 o = hash32( n + g );
        vec2 r = g + o.xy - f;
        md = min( md, dot(r,r) - o.z*o.z );
    }
    
    return md;
}

// Power Diagram edges,
// returns closest distance to edge and closest cell with squared weight
vec4 power_diagram( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);
    #if ACCURACY == 2
    // shift by half-cell
    vec2 h = step(.5,f) - 2.;
    n += h; f -= h;
    #endif
    
    vec3 mr;

    //--------------------------------------------------
    // 1st pass: find weighted Voronoi cell for "x"
    float md = MAX_D;
    #if ACCURACY == 2
    for( int j=0; j<=3; j++ )
    for( int i=0; i<=3; i++ )
    #else
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    #endif
    {
        vec2 g = vec2(float(i),float(j));
        vec3 o = hash32( n + g );
        vec2 r = g + o.xy - f;
        float w = o.z*o.z;
        float d = dot(r,r) - w;

        if( d<md )
        {
            md = d;
            mr = vec3(r, w);
        }
    }
    //--------------------------------------------------
    
    #if ACCURACY == 1
    // shift by half-cell
    vec2 h = step(.5,f) - 2.;
    n += h; f -= h;
    #endif

    //--------------------------------------------------
    // 2nd pass: find closest weighted Voronoi edge
    md = MAX_D;
    #if ACCURACY >= 1
    for( int j=0; j<=3; j++ )
    for( int i=0; i<=3; i++ )
    #else
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    #endif
    {
        vec2 g = vec2(float(i),float(j));
        vec3 o = hash32( n + g );
        vec2 r = g + o.xy - f;
        vec2 dr = r - mr.xy;
        float d = dot(dr,dr);
        if( d>EPSILON ) {
           float mf = (mr.z - o.z*o.z + d) / (2.*d);
           md = min( md, dot( mix(mr.xy,r,mf), dr*(1./sqrt(d)) ) );
        }
    }
    //--------------------------------------------------

    return vec4(md, mr);
}

// Fast voronoi to get closest distance to generator points,
// implemented/re-implemented by others many, many times already
float fast_voronoi( in vec2 x )
{
    x -= .5;
    vec2 n = floor(x);
    vec2 f = fract(x) + .5;
    
    float md = MAX_D;
    for( int j=0; j<=1; j++ )
    for( int i=0; i<=1; i++ )
    {
        vec2 g = vec2(float(i),float(j));
        vec3 o = hash32( n + g );
        vec2 r = g + o.xy - f;
        md = min(md, dot(r,r));
    }
    
    return md;
}

vec3 plot( vec2 p, vec2 template_cursor, float ss )
{
   // Colors:
   const vec3 interior = vec3(.2,.8,1.);
   const vec3 exterior = vec3(1.,.4,.1);
   const vec3 border = vec3(.1,.7,.3);
   const vec3 point = vec3(1.,.5,0.);

#if SHOW_MODE == 2
   if (iMouse.z > 0.)
   {
#endif
#if SHOW_MODE != 0
   float c = sqrt(fast_voronoi(p));
   float d = closest_circle(p);
   float d2 = abs(d);
   vec3 col =
       mix(
           mix(
               (d2*1.4+.05)*mix(exterior,interior,sign(d)*.5+.5)*min(1.,d2*18.),
               border,
               smoothstep(.03,.01,d2)
           )*min(1.,c*9.),
           point,
           smoothstep(.07,.05,c)
       );
   #if SHOW_MODE != 2
   float dc = length(p - template_cursor);
   if (dc < 2.) {
       dc = abs(dc - abs(closest_circle(template_cursor)) + .03);
       col = mix(col,vec3(1),smoothstep(ss,.0,dc));
   }
   #endif
   return pow(col,vec3(.85));
#endif
#if SHOW_MODE == 2
   }
#endif
#if SHOW_MODE != 1
   vec4 cp = power_diagram(p);
   float c = cp.x;
    
   float d = length(cp.yz);
   //float d1 = sqrt(fast_voronoi(p));
   float d2 = d - sqrt(cp.w);
   float d3 = (1.-smoothstep(.06,.02,c));
   vec3 col =
   mix(      
      mix(
         mix(
            (c*1.4+.05)*(sin(c*120.)*.1+.9)*interior*d3*min(1.,d*9.),
            point,
            smoothstep(.07,.05,d)
         )*clamp(abs(d2)*18.,.7,1.),
         point*d3,
         max(smoothstep(.03,.01,abs(d2))*.5,
             smoothstep(.03,.01,d2)*.2)
      ),
      border*(smoothstep(0.,.015,c)*.5+.5),
      smoothstep(.04,.02,c)
   );
   #if SHOW_MODE != 2
   float dc = length(p - template_cursor);
   if (dc < 2.) {
      dc = abs(dc - abs(power_diagram(template_cursor).x) + .03);
      col = mix(col,vec3(1),smoothstep(ss,.0,dc));
   }
   #endif
   return pow(col,vec3(.85))*1.2;
#endif
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float sc = step(512., iResolution.y)*4. + 4.; // scale differently for fullscreen
	vec2 uv = (fragCoord.xy - iResolution.xy*.5) * sc / iResolution.y;
    vec2 cursor = (abs(iMouse.xy) - iResolution.xy*.5) * sc / iResolution.y;
	fragColor = vec4(plot(uv, cursor, sc/iResolution.y), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

